<?php



	// -------------------------------------------------- //
	//                  PROPERTIES
	// -------------------------------------------------- //

	// download a ttf font here for example : http://www.dafont.com/fr/nottke.font
	$font     = 'arial.ttf';
	// - -

	$fontSize = 20;   	// GD1 in px ; GD2 in point
	$marge    = 8;   	// between barcode and hri in pixel
	$x        = 275;  	// barcode center
	$y        = 55;  	// barcode center
	$height   = 90;   	// barcode height in 1D ; module size in 2D
	$width    = 5;    	// barcode height in 1D ; not use in 2D
	$angle    = 0;   	// rotation in degrees : nb : non horizontable barcode might not be usable because of pixelisation

	$code 	  = $_GET['code'];
	$type     = 'EAN13';
	$design	  = 'carnet1.png';
	$photo	  = 'user.jpg';
	$file	  = $code.'.png'; 


	// -------------------------------------------------- //
	//                      GENERATE BARCODE
	// -------------------------------------------------- //
	include('php-barcode.php');

	// -------------------------------------------------- //
	//            ALLOCATE GD RESSOURCE
	// -------------------------------------------------- //
	$im     = imagecreatetruecolor(550, 140);
	$black  = ImageColorAllocate($im,0x00,0x00,0x00);
	$white  = ImageColorAllocate($im,0xff,0xff,0xff);
	$red    = ImageColorAllocate($im,0xff,0x00,0x00);
	$blue   = ImageColorAllocate($im,0x00,0x00,0xff);
	imagefilledrectangle($im, 0, 0, 550, 140, $white);

	$data = Barcode::gd($im, $black, $x, $y, $angle, $type, array('code'=>$code), $width, $height);

	// -------------------------------------------------- //
	//                        HRI
	// -------------------------------------------------- //
	if ( isset($font) ){
		$box = imagettfbbox($fontSize, 0, $font, $data['hri']);
		$len = $box[2] - $box[0];
		Barcode::rotate(-$len / 2, ($data['height'] / 2) + $fontSize + $marge, $angle, $xt, $yt);
		imagettftext($im, $fontSize, $angle, $x + $xt, $y + $yt, $blue, $font, $data['hri']);
	}


	// -------------------------------------------------- //
	//                    GENERATE IMAGE
	// -------------------------------------------------- //

	$img = imagecreatefrompng($design);

	$pos = array(
		array(
		array(26,102),array(435,225),array(435,302),array(435,387),array(435,467),$black),
		array(
		array(37,81),array(420,252),array(420,329),array(420,406),array(420,483),$black),
		array(
		array(26,107),array(417,204),array(417,299),array(417,391),array(417,481),$black),
		array(
		array(35,93),array(559,171),array(559,249),array(559,329),array(559,406),$white)
	);

	$tipo=1;

	if($photo){
		$img_ = imagecreatefromjpeg($photo);
		$tamano = getimagesize($photo);
		imagecopyresampled($img,$img_,$pos[$tipo-1][0][0],$pos[$tipo-1][0][1],0,0,356,475,$tamano[0],$tamano[1]);

	}

	imagettftext($img, 20, 0, $pos[$tipo-1][1][0], $pos[$tipo-1][1][1], $pos[$tipo-1][5], $font, 'Pozo');
	imagettftext($img, 20, 0, $pos[$tipo-1][2][0], $pos[$tipo-1][2][1], $pos[$tipo-1][5], $font, 'Saldaña');
	imagettftext($img, 20, 0, $pos[$tipo-1][3][0], $pos[$tipo-1][3][1], $pos[$tipo-1][5], $font, 'Juan Carlos');
	imagettftext($img, 20, 0, $pos[$tipo-1][4][0], $pos[$tipo-1][4][1], $pos[$tipo-1][5], $font, 'Ingeniería');

	imagecopy($img,$im,440,505,0,0,550,140);

	header('Content-Type: image/png'); 
	//imagepng($img); 
	//imagedestroy($im); 

	imagepng($img,$file);		//Descarga archivo
	imagepng($img)				//muestra archivo
  	//imagedestroy($im);

?>