<?php
session_start(); // Iniciar sesion

// Verificar si el usuario ha iniciado sesion
if (!isset($_SESSION['user_id'])) {
    header('Location: ../login.php'); // Redirigir al login si no ha iniciado sesion
    exit();
}

require '../conexion.php'; // Incluir la conexion a la base de datos
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <title>CREDENCIALES</title>

    <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="bootstrap/css/bootstrap-theme.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
</head>
<body>

    <section>
        <div class="container">
            <div class="fondo">
                <h3>USUARIO<small> / ITAE </small></h3>
                <p>Bienvenido, <?= htmlspecialchars($_SESSION['username'], ENT_QUOTES) ?></p>
                <a href="https://genova.edu.pe/Credenciales/logout.php" class="btn btn-danger">Cerrar Sesion</a>
            </div>
            <br/>

            <p>Al hacer uso de este sistema de generacion de Credenciales o carnet de estudiante, usted esta aceptando los terminos y condiciones del servicio, asi como las politicas de privacidad de la informacion LEY 29733.</p>

            <form action="generar_carnet.php" method="POST" enctype="multipart/form-data">
                <div class="row">
                    <div class="col-sm-8">
                        <div class="col-sm-3">
                            <label>Codigo:</label>
                        </div>
                        <div class="col-sm-5">
                            <input type="text" class="form-control" name="txtcodigo" id="txtcodigo" placeholder="Ingrese codigo" required>
                        </div>
                        <br/><br/>
                        <div class="col-sm-3">
                            <label>Correo:</label>
                        </div>
                        <div class="col-sm-5">
                            <input type="text" class="form-control" name="txtnombres" id="txtnombres" placeholder="Ingrese correo institucional" required autofocus>
                        </div>
                        <br/><br/>
                        <div class="col-sm-3">
                            <label>Nombres:</label>
                        </div>
                        <div class="col-sm-5">
                            <input type="text" class="form-control" name="txtapellidop" id="txtapellidop" placeholder="Ingrese Nombres" required>
                        </div>
                        <br/><br/>
                        <div class="col-sm-3">
                            <label>Apellidos:</label>
                        </div>
                        <div class="col-sm-5">
                            <input type="text" class="form-control" name="txtapellidom" id="txtapellidom" placeholder="Ingrese Apellidos" required>
                        </div>
                        <br/><br/>
                        <div class="col-sm-3">
                            <label>Programa de Estudio:</label>
                        </div>
                        <div class="col-sm-5">
                            <input type="text" class="form-control" name="txtcargo" id="txtcargo" placeholder="Ingrese Programa de Estudio" required>
                        </div>
                        <br/><br/>
                        <div class="col-sm-3">
                            <label>Imagen del Estudiante:</label>
                        </div>
                        <div class="col-sm-5">
                            <input type="file" class="form-control" name="imagenEstudiante" id="imagenEstudiante" accept="image/*">
                        </div>
                        <br/><br/>
                    </div>
                </div>
                <br/>
                <div class="row">
                    <div class="form-group">
                        <input type="submit" class="btn btn-primary" name="btngrabar" id="btngrabar" value="Generar Carnet">
                    </div>
                </div>
            </form>
            <br/>
        </div>
    </section>

    <script src="js/jquery-1.11.2.min.js"></script>
    <script src="bootstrap/js/bootstrap.min.js"></script>

</body>
</html>